import Flag from "@/img/flag.png"
import Link from "next/link";

import Image from "next/image"
import { Search, ShoppingCart, Phone} from "lucide-react"
import { useEffect, useState } from "react";
import { ProductProps } from "@/lib/features/web/type";
import { url } from "@/lib/constant";
import axios from "axios";

export default function Header() {

  const [search, setSearch] = useState("");
  const [results, setResults] = useState<ProductProps[]>([]);

  const [showDropdown, setShowDropdown] = useState(false);

  useEffect(() => {
    const delayDebounce = setTimeout( async() => {

      try {
      if (search.trim().length > 0) {
        await axios.get(`${url}/product/search?q=${search}`)
          .then(res => {
            setResults(res.data)
            setShowDropdown(true)
          })
      } else {
        setResults([])
        setShowDropdown(false)
      }
      } catch (error) {
        console.log(error);
        setResults([])
        setShowDropdown(false)
      }

    }, 300)

    return  () =>  clearTimeout(delayDebounce)
  }, [search])


  return (
    <>
      <header className="text-white" 
        style={{
          backgroundImage: "linear-gradient(179deg, rgb(10, 112, 227) 0.46%, rgb(3, 78, 162) 87.03%)"
        }}
      >
        <div className="container-fluid mx-auto px-4 py-3">
          <div className="flex flex-col md:flex-row items-center justify-between gap-4">
            <div className="flex items-center gap-2">
              <Link href="/" className="text-2xl font-bold text-white">
                Kigaliphoneskt
              </Link>
              <Image
                src={Flag}
                alt="Rwanda Flag"
                width={56}
                height={44}
                className="ml-2"
              />
              <span className="hidden md:inline-block ml-4">Deliver to Rwanda</span>
            </div>

            <div className="flex-1 max-w-xl">
              <div className="relative">
                <input
                  type="text"
                  placeholder="Search products..."
                  className="w-full py-2 px-4 rounded-md text-black"
                  value={search}
                  onChange={e => setSearch(e.target.value)}

                />
                <button className="absolute right-0 top-0 h-full bg-blue-500 px-4 rounded-r-md"
                  //onClick={() => SearchProduct()}
                >
                  <Search className="text-white" />
                </button>

                {showDropdown && results?.length > 0 && (
                  <ul className="absolute z-10 bg-white border rounded-md shadow-lg mt-1 w-full max-h-60 overflow-y-auto">
                    {results?.map(product => (
                      <li key={product?.tbl_productToken}>
                        <Link  href={`/view/${product?.tbl_productToken}`}
                          className="block px-4 py-2 hover:bg-gray-100 text-black"
                          onClick={() => setShowDropdown(false)}
                        >
                          {product?.tbl_productBrand}
                        </Link>
                      </li>
                    ))}
                  </ul>
                )}
              </div>
            </div>

            <div className="flex items-center gap-4">
              <Link href="#" className="flex items-center gap-1">
                <ShoppingCart />
                <span>Cart(0)</span>
              </Link>
              <Link href="#" className="flex items-center gap-1">
                <span>Orders</span>
              </Link>
              <Link href="https://wa.me/250788889611" className="flex items-center gap-1">
                <Phone />
                <span>0788 889 611</span>
              </Link>
            </div>
          </div>
        </div>

      </header>


        </>

  )

}
      