"use client"
import Image from "next/image"
import Slider from "react-slick"

import { AdProps } from "@/lib/features/web/type"
import { imageurl } from "@/lib/constant"

interface Props {
  ads: AdProps[];
}

export default function PromoBanner({ ads }: Props) {
  if (!ads || ads.length === 0) return null;

  const settings = {
    dots: true,
    infinite: true,
    speed: 500,
    slidesToShow: 1,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    arrows: false,
    adaptiveHeight: false,
  }

  return (
    <div className="w-full mx-auto overflow-hidden">
      <Slider {...settings}>
        {ads?.map((adItem: AdProps, index: number) => (
<div key={index} className="relative w-full" style={{ height: 'auto', minHeight: '200px' }}>
  <Image 
    src={`${imageurl}img/${adItem?.tbl_adPhoto}`}
    width={1200}  // Actual image width
    height={400}  // Actual image height
    className="w-full h-auto"
    alt=""
    priority
  />
</div>
        ))}
      </Slider>
    </div>
  )
}